#pragma once
#include <stdint.h>

enum class EngineRunning_t { ON, OFF };
enum class CrashDetected_t { CRASH, NO_CRASH };
enum class LockState_t { LOCKED, UNLOCKED };
enum class LockMode_t { AUTO_LOCK , MANUAL_LOCK };

class CarData
{
private:
    int VIN;
    EngineRunning_t EngineRunning;
    CrashDetected_t CrashDetected;
    LockState_t LockState;
    LockMode_t LockMode;
    uint16_t Velocity;
public:
    // Constructor
    CarData(int VIN = 100, EngineRunning_t EngineRunning = EngineRunning_t::OFF, CrashDetected_t CrashDetected = CrashDetected_t::NO_CRASH, LockState_t LockState = LockState_t::UNLOCKED, LockMode_t LockMode = LockMode_t::AUTO_LOCK, uint16_t Velocity =  0);

    // Copy constructor 
    CarData(const CarData& source);

    // Destructor
    ~CarData();

    //get VIN
    int get_VIN() const { return this->VIN; }
    //set VIN
    void set_VIN(int VIN) { this->VIN = VIN; }

    //get EngineRunning
    EngineRunning_t get_EngineRunning() const { return EngineRunning; }
    //set EngineRunning
    void set_EngineRunning(EngineRunning_t EngineRunning) { this->EngineRunning = EngineRunning; }

    //get CrashDetected
    CrashDetected_t get_CrashDetected() const { return CrashDetected; }
    //set CrashDetected
    void set_CrashDetected(CrashDetected_t CrashDetected) { this->CrashDetected = CrashDetected; }

    //get LockState
    LockState_t get_LockState() const { return LockState; }
    //set LockState
    void set_LockState(LockState_t LockState) { this->LockState = LockState; }

    //get LockMode
    LockMode_t get_LockMode() const { return LockMode; }
    //set LockMode
    void set_LockMode(LockMode_t LockMode) { this->LockMode = LockMode; }

    //get Velocity
    uint16_t get_Velocity() const { return Velocity; }
    //set Velocity
    void set_Velocity(uint16_t Velocity) { this->Velocity = Velocity; }

    virtual void checkAutoLock(void);
    void process_velocity_message(int velocity);
};
